VERSION 5.00
Object = "{DFEB0DA3-D648-11D4-9C5F-EA48B7E9393D}#1.0#0"; "tvc.ocx"
Begin VB.Form frmCH5_VB 
   Caption         =   "CH 5 Visual Basic Demo"
   ClientHeight    =   6024
   ClientLeft      =   13056
   ClientTop       =   -3528
   ClientWidth     =   9204
   LinkTopic       =   "Form1"
   ScaleHeight     =   6024
   ScaleWidth      =   9204
   Begin VB.ListBox lstDevices 
      Height          =   1392
      Left            =   6600
      TabIndex        =   23
      Top             =   3480
      Width           =   1575
   End
   Begin VB.Frame Frame3 
      Caption         =   "Send GPIB commands"
      Height          =   2535
      Left            =   240
      TabIndex        =   16
      Top             =   3360
      Width           =   4455
      Begin VB.CheckBox chkHasReturn 
         Caption         =   "Has Return Value"
         Height          =   255
         Left            =   120
         TabIndex        =   24
         Top             =   2040
         Width           =   1575
      End
      Begin VB.CommandButton cmdClearMResults 
         Caption         =   "Clear"
         Height          =   375
         Left            =   3240
         TabIndex        =   21
         Top             =   2040
         Width           =   1095
      End
      Begin VB.CommandButton cmdSendCmd 
         Caption         =   "Send Command"
         Height          =   375
         Left            =   1800
         TabIndex        =   18
         Top             =   2040
         Width           =   1335
      End
      Begin VB.TextBox txtGPIB 
         Height          =   375
         Left            =   120
         TabIndex        =   17
         Top             =   240
         Width           =   4095
      End
      Begin VB.Label lblManualResults 
         BorderStyle     =   1  'Fixed Single
         Height          =   1215
         Left            =   840
         TabIndex        =   20
         Top             =   720
         Width           =   3135
         WordWrap        =   -1  'True
      End
      Begin VB.Label Label7 
         Caption         =   "Results"
         Height          =   255
         Left            =   120
         TabIndex        =   19
         Top             =   720
         Width           =   735
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Waveform Data"
      Height          =   3135
      Left            =   4080
      TabIndex        =   2
      Top             =   120
      Width           =   4935
      Begin VB.CommandButton cmdClear 
         Caption         =   "Clear"
         Height          =   375
         Left            =   1560
         TabIndex        =   9
         Top             =   2280
         Width           =   975
      End
      Begin VB.CommandButton cmdGetWaveForm 
         Caption         =   "Get WaveForm"
         Height          =   375
         Left            =   120
         TabIndex        =   8
         Top             =   2280
         Width           =   1335
      End
      Begin VB.CheckBox chkDisplayWF 
         Caption         =   "Display Wave Form Values"
         Height          =   375
         Left            =   120
         TabIndex        =   6
         Top             =   1800
         Width           =   2295
      End
      Begin VB.ListBox lstWF 
         Height          =   2544
         ItemData        =   "frmCH5_VB.frx":0000
         Left            =   2640
         List            =   "frmCH5_VB.frx":0002
         TabIndex        =   3
         Top             =   240
         Width           =   1935
      End
      Begin VB.Label Label6 
         Caption         =   "Trigger Position"
         Height          =   255
         Left            =   120
         TabIndex        =   13
         Top             =   1320
         Width           =   1215
      End
      Begin VB.Label lblTrigPos 
         BorderStyle     =   1  'Fixed Single
         Height          =   375
         Left            =   1320
         TabIndex        =   12
         Top             =   1200
         Width           =   975
      End
      Begin VB.Label Label4 
         Caption         =   "Record Length"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   360
         Width           =   1095
      End
      Begin VB.Label lblRecLength 
         BorderStyle     =   1  'Fixed Single
         Height          =   375
         Left            =   1320
         TabIndex        =   10
         Top             =   240
         Width           =   975
      End
      Begin VB.Label Label2 
         Caption         =   "Interval"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   840
         Width           =   855
      End
      Begin VB.Label lblInterval 
         BorderStyle     =   1  'Fixed Single
         Height          =   375
         Left            =   1320
         TabIndex        =   4
         Top             =   720
         Width           =   975
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Measurement Commands"
      Height          =   3135
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3855
      Begin VB.ListBox lstMeasurement 
         Height          =   2160
         ItemData        =   "frmCH5_VB.frx":0004
         Left            =   1920
         List            =   "frmCH5_VB.frx":0006
         TabIndex        =   7
         Top             =   240
         Width           =   1815
      End
      Begin VB.CommandButton cmdMeasure 
         Caption         =   "Get IMM Measurement"
         Height          =   495
         Left            =   240
         TabIndex        =   1
         Top             =   600
         Width           =   1455
      End
      Begin VB.Label Label1 
         Caption         =   "Results:"
         Height          =   255
         Left            =   240
         TabIndex        =   15
         Top             =   2160
         Width           =   855
         WordWrap        =   -1  'True
      End
      Begin VB.Label lblDisplay 
         BorderStyle     =   1  'Fixed Single
         Height          =   375
         Left            =   120
         TabIndex        =   14
         Top             =   2520
         Width           =   3615
      End
   End
   Begin TVCLib.Tvc Tvc1 
      Left            =   5280
      Top             =   3960
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      VisaDescriptor  =   "GPIB8::1::INSTR"
      SearchCriterion =   0
   End
   Begin VB.Label Label8 
      Caption         =   "Current Device:"
      Height          =   255
      Left            =   5160
      TabIndex        =   22
      Top             =   3480
      Width           =   1335
   End
End
Attribute VB_Name = "frmCH5_VB"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Private Sub cmdClear_Click()
   ' clear controls which display waveform data

   lstWF.Clear
   lblRecLength.Caption = ""
   lblInterval.Caption = ""
   lblTrigPos.Caption = ""
   
End Sub

Private Sub cmdClearMResults_Click()
  ' clear GPIB command controls
  txtGPIB.Text = ""
  lblManualResults.Caption = ""
End Sub

Private Sub cmdGetWaveForm_Click()
   ' declare variables
   Dim arrWF As Variant 'array variable which will hold waveform values
   Dim xinc As Double ' variable which will hold the x axis increment
   Dim trigpos As Long ' variable which hold the timing trigger position
   Dim i As Long  ' counter variable
   Dim vUnits As String, hUnits As String
   
   On Error GoTo cmdGetWFMErr
   
   'CH1 is the OCX built-in constant specifying Channel 1
    Call Tvc1.GetWaveform(CH1, arrWF, xinc, trigpos, vUnits, hUnits)
   
   
   If IsArray(arrWF) Then  ' check to be sure returned value is an array
       lblRecLength.Caption = UBound(arrWF) - LBound(arrWF) + 1
   Else
      Exit Sub
   End If
   lblInterval.Caption = xinc
   lblTrigPos.Caption = trigpos
   
   If chkDisplayWF.Value = vbChecked Then  ' if user wants values displayed, loop through the array
       For i = LBound(arrWF) To UBound(arrWF)
          lstWF.AddItem arrWF(i)
       Next
   End If
   
   Exit Sub

cmdGetWFMErr:
  MsgBox "Error: " & Err.Number & ", " & Err.Description
End Sub

Private Sub cmdMeasure_Click()
  Dim strID As String
  lblDisplay.Caption = ""   ' clear the label which will display the result
  ' construct the GPIB command
  strID = "MEASUREMENT:IMMED:TYPE " & lstMeasurement.Text & "; VAL?;:HEADER OFF"
  ' send the command
  Tvc1.WriteString strID
 ' read the result and display it
  lblDisplay.Caption = Tvc1.ReadString
End Sub

Private Sub cmdSendCmd_Click()
  Dim strCmd As String, strResult As String
  On Error GoTo cmdSendCmdErr
  
  'send the user's GPIB command
  strCmd = txtGPIB.Text
  Tvc1.WriteString strCmd
  ' check to see if the user expects a return value
  If CBool(chkHasReturn.Value) Then
      strResult = Tvc1.ReadString
      Debug.Print strResult
      lblManualResults.Caption = strResult
  Else
      lblManualResults.Caption = ""
  End If
  
Exit Sub

cmdSendCmdErr:
  MsgBox "Error: " & Err.Number & ", " & Err.Description
End Sub

Private Sub Form_Load()
   Dim dev As Variant  ' array that holds devices detected by the OCX control
   Dim i As Integer
   Dim SetFlag As Boolean
   
   SetFlag = False
   
   ' add GPIB immediate measurement commands to the list box
   With lstMeasurement
      .AddItem "AMPLITUDE"
      .AddItem "AREA"
      .AddItem "BURST"
      .AddItem "CAREA"
      .AddItem "CRMS"
      .AddItem "DELAY"
      .AddItem "FALL"
      .AddItem "FREQUENCY"
      .AddItem "HIGH"
      .AddItem "LOW"
      .AddItem "MAXIMUM"
      .AddItem "MINIMUM"
      .AddItem "NDUTY"
      .AddItem "NOVERSHOOT"
      .AddItem "NWIDTH"
      .AddItem "PDUTY"
      .AddItem "PERIOD"
      .AddItem "PHASE"
      .AddItem "PK2PK"
      .AddItem "POVERSHOOT"
      .AddItem "PWIDTH"
      .AddItem "RISE"
      .AddItem "RMS"
      
    .ListIndex = 0
   
   End With
   
   Tvc1.SearchCriterion = 0  'search  all devices
   ' get detected VISA devices
   dev = Tvc1.FindList
   ' populate devices listbox
   If IsArray(dev) Then
       For i = LBound(dev) To UBound(dev)
          lstDevices.AddItem dev(i)
       Next
   End If
   
   ' Set to Internal Device on TekScopes if available
   For i = 0 To lstDevices.ListCount - 1
    If Left(lstDevices.List(i), 5) = "GPIB8" Then
         lstDevices.ListIndex = i
         Tvc1.Descriptor = lstDevices.Text
         SetFlag = True
         Exit For
     End If
   Next
   
   If Not SetFlag Then
    ' Set to first GPIB device since no internal device found
    For i = 0 To lstDevices.ListCount - 1
       If Left(lstDevices.List(i), 4) = "GPIB" Then
            lstDevices.ListIndex = i
            Tvc1.Descriptor = lstDevices.Text
            SetFlag = True
            Exit For
        End If
    Next
   End If
       
   Me.Left = Screen.Width / 10
   Me.Top = Screen.Width / 10
   
       
End Sub


